<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('nom', 'prenom', 'telephone', 'email', 'id_user');
    protected $visible = array('nom', 'prenom', 'telephone', 'email', 'id_user');

    public function ventes()
    {
        return $this->hasMany('App\Models\Vente', 'id_client');
    }

}